使用集成C代码插件，可以在MetaFacture工程中包含外部实现的C代码文件，可以从IEC对象生成C存根。

在MetaFacture中，***C代码模块***对象类型可用于此目的。C代码文件和使用的IEC对象位于***C代码模块***的下面。硬盘上的一个文件目录与C代码文件被分配给每个C代码模块。

在这个项目中，您可以从C代码文件中以\*.h或\*.hpp的格式生成IEC对象(头文件)，以便在其他POUs中使用它们。

生成c存根的目的是为了以下用例:

- C代码文件访问IEC对象: C代码文件不能直接访问IEC对象。它只能访问由IEC对象生成的C存根。
- 生成可合并到库工程中的预编译模块。

导入后，导入的源代码文件是MetaFacture项目的一部分，因此它们与磁盘上的原始文件解耦。

在编译期间，从C代码模块生成一个动态模块，并将其保存为项目的一部分。信息、警告和错误显示在***C代码模块***类别的消息视图中。

在下载过程中，应用程序的所有动态模块都被传输并加载到Runtime系统。Runtime系统必须为此支持动态链接。

**注意：Runtime系统的许可证**

Runtime系统需要一个允许加载C模块的许可证。没有此许可证，动态模块在下载期间无法链接，因此下载将被中止。

动态模块是启动应用程序的一部分，它们在控制器重新启动时被重新加载和激活。***Reset Origin***命令卸载应用程序中的所有C代码模块。***冷复位***和***热复位***命令不会导致C代码模块的重复初始化。

**提示：没有C代码的模拟模式！**

在模拟模式下，不生成C代码并将其加载到runtime系统。为了模拟C模块中包含的代码，您可以在C代码模块的各个IEC对象中实现这一目标。

MetaFacture不支持在C代码文件中监视变量或在C源代码中设置断点。

**库中预编译模块:**

C代码集成提供了分配预编译Runtime模块的功能(例如: \*.dll)在库中保存一个设备，然后将其保存在库中。然后，可以动态加载这些模块。

---

### 配置C代码模块​

要求：打开的项目已经包含一个![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/6721984b99fff.png)C代码模块。

1.单击设备树中的![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/6721985eed5f9.png)工程***C代码模块***。

2.右键菜单中选择***属性***命令

3.在***属性***对话框中打开***编译***标签。

4.指定计算机上Visual Studio安装的文件路径。输入助手（ ![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/672198ad19f9d.png)）和搜索工具(放大镜)也可用。

5.指定安装在计算机上的MS Windows SDK的文件路径。输入助手（ ![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/672198b07571f.png)）和搜索工具(放大镜)也可用。

6.指定用于MetaFacture存储临时编译文件的文件路径。

---

### 从文件目录导入包含C源文件的文件夹​

要求：一个工程是开放的。工程控制器支持C代码的集成。

  
1.在设备树中选择***Application***点击***工程 ➔ 添加对象 ➔ C代码模块***。

2.如果需要，在***添加C代码模块***对话框中为您的C代码模块指定一个新名称。如果您不这样做，那么您的对象将被赋予标准名称***C代码模块***。

3.单击***源目录***输入字段旁边的符号（![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/672198fde5c64.png)）。

4.打开***查找文件夹***对话框。

5.在***查找文件夹***对话框中，选择包含C源文件的文件夹 (\*.c, \*.cpp, \*.h, or \*.hpp)。

6.当选择***用于源代码更改的监视文件夹***选项时，MetaFacture将在对文件系统选定文件夹中的C源文件进行更改时显示一条消息。

7.点击添加。  
⇒MetaFacture使用文件夹***扩展名、IEC接口***和***源文件***将C代码模块插入到设备树中。

8.在设备树中，单击***源文件***文件夹的加号(***+***)。⇒在打开文件夹中列出了导入的C源文件。

9.如果双击其中一个C源文件( ![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219961ec56c.png))，则C代码文件将在编辑器中打开。

---

### 导入单独的C代码文件​

要求：打开的项目已经包含一个![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/672199d35597c.png)C代码模块。

  
1.单击设备树中的![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/672199d75883f.png)工程C***代码模块***。

2.点击***工程 ➔ 添加对象 ➔ C代码文件***。

3.在***添加C代码文件***对话框中，使用输入助手（ ![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/672199faed333.png)）在 \*.c,\*.cpp,\*.h,或\*.hpp格式中选择一个文件，然后单击***添加***。  
⇒MetaFacture将选择的C代码文件插入到![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219a109a422.png)***C代码模块***下面的设备树中。

4.如果双击设备树中的新C代码文件(![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219a180eb63.png))，它将在编辑器中打开以进行修改。

---

### 生成空的C代码文件​

要求：打开的项目已经包含一个![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219a354fc90.png)C代码模块。

  
1.单击设备树中的![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219a3e8fe13.png)工程***C代码模块***。

2.点击***工程 ➔ 添加对象 ➔ C代码文件***。

3.在“***添加C代码文件***”对话框中，使用适当的文件扩展名指定新C代码文件的名称，然后单击“***添加***”。  
⇒MetaFacture将选择的C代码文件插入到![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219a747c5cf.png)***C代码模块***下面的设备树中。

4.如果双击设备树中的新C代码文件(![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219a7c7cd35.png))，它将在编辑器中打开以进行修改。

---

### 将C代码文件转换成IEC对象，在应用程序中用作编程对象 ​

要求：打开的项目包括![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219a9ea70f0.png)C代码模块和![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219aa47eb18.png)C代码文件。例如，C代码文件包含以下C代码: int adder(int a, int b);

  
1.单击![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219aaae0d3a.png)文件扩展名为\*.h的C代码文件。在例子中，他是test.h文件。

2.点击***编译 ➔ C-Integration ➔ 创建IEC接口***  
⇒***创建C接口***对话框打开并列出文件test.h及其函数adder (int, int)。导入时激活了这两个变量。

3.点击**导入**。

4.MetaFacture生成***adder (FUN)***函数并将其作为对象插入设备树中的***IEC接口***文件夹中。

5.当您双击***adder (FUN)***对象时，它将在编辑器中打开。  
⇒包含以下声明部分:  
![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219b0010ff8.png)  
   
6.现在可以在POU的实现部分调用adder函数(例如:adder (diVar1, diVar2);)。

---

### 创建C存根​

要求：打开的项目包含一个![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219b305b9e1.png)C代码模块。一个POU被添加到C代码模块，这个POU已经实现了代码。

  
1.在设备树中，选择C代码模块下面的POU，然后单击 ***C-Integration ➔ Create Stub Implementation in C***。  
⇒MetaFacture创建对象***iec\_external.c***和***iec\_external.h***，并将它们添加到设备树中的***扩展***文件夹。  
 在消息视图(***C代码模块***类别)中，您将发现一条消息，说明已经成功创建了一个m4文件。

注意：当您在单击在***C中创建存根实现***时，应用程序将自动编译。如果过程中出现错误，则这些错误将在消息视图中显示。另外，请监视***C代码模块***类别中的消息。

---

### 将预编译的Runtime模块分配给设备并将其保存到库中​

要求：在MetaFacture中一个库(\*.library)是打开的。

  
1.点击***视图 ➔ POUs***。  
⇒**POUs**视图打开并显示库项目及其对象。

2.选择库工程并且点击***工程 ➔ 添加对象 ➔ C-Implemented库***。

  
3.在***添加C-Implemented***库对话框中点击添加。  
⇒MetaFacture将对象![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219c312b227.png)***C实现的库***添加到***POUs***视图。

4.双击![](https://resource.helplook.net/docker_production/3648ne/article/9EwAtvMe/67219c4dae054.png)***C Implemented***库对象。  
⇒对象在其编辑器中打开

5.在这个编辑器中点击***添加***。  
⇒***选择设备***对话框打开。

6.在目标文件输入字段中，以\*.dll或\*.so格式指定可动态加载模块的名称。  
   
**提示！**dll文件必须在其名称中包含库项目的标题。例如，如果库项目被命名为XYlib，那么***对象文件***必须被调用: \_XYlib.dll.

7.在***设备***窗口中，选择用于分配***目标文件***的设备。

8.点击***选择设备***⇒MetaFacture在***已编译组件***的选项卡编辑器中显示已创建的设备文件分配。

9.保存库工程。